// EditHolidayGroup.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "EditHolidayGroup.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditHolidayGroup dialog


CEditHolidayGroup::CEditHolidayGroup(CWnd* pParent /*=NULL*/)
	: CDialog(CEditHolidayGroup::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditHolidayGroup)
	m_bEveryYear = FALSE;
	m_sHolName = _T("");
	m_sOldHGName = _T("");
	m_sNewHGName = _T("");
	m_sExHGName = _T("");
	m_sHolName = _T("");
	m_lDay = 0;
	m_lMonth = 0;
	m_lYear = 0;
	//}}AFX_DATA_INIT
}
CEditHolidayGroup ::CEditHolidayGroup(IApplication *pApp):CDialog(CEditHolidayGroup::IDD, NULL)
{
	pApplication = pApp;
	pHolGrp.CreateInstance(__uuidof(HolidayGroup));
	//m_saHolidays.CreateOneDim(VT_DISPATCH,1);
	m_lHolCount = 0;

	m_lDay = 0;
	m_lYear = 0;
	m_lMonth = 0;
}


void CEditHolidayGroup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditHolidayGroup)
	DDX_Control(pDX, IDC_COMBO_HOLIDAYLIST, m_HolidayList);
	DDX_Control(pDX, IDC_COMBO_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_COMBO_HOLGRPLIST, m_HolGrpList);
	DDX_Check(pDX, IDC_CHECK_EVERYYEAR_HGEDIT, m_bEveryYear);
	DDX_Text(pDX, IDC_NAME_HOLIDAY_HGEDIT, m_sHolName);
	DDX_Radio(pDX, IDC_RADIO_HOLIDAY1_HGEDIT, m_iHolType);
	DDX_Text(pDX, IDC_EDIT_HG_NAME, m_sNewHGName);
	DDX_Text(pDX, IDC_EDIT_EX_HGNAME, m_sExHGName);
	DDX_Text(pDX, IDC_EDIT_DAY4, m_lDay);
	DDX_Text(pDX, IDC_EDIT_MONTH4, m_lMonth);
	DDX_Text(pDX, IDC_EDIT_YEAR4, m_lYear);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditHolidayGroup, CDialog)
	//{{AFX_MSG_MAP(CEditHolidayGroup)
	ON_CBN_SELCHANGE(IDC_COMBO_ACCTLIST, OnSelchangeComboAcctlist)
	ON_CBN_SELCHANGE(IDC_COMBO_HOLGRPLIST, OnSelchangeComboHolgrplist)
	ON_BN_CLICKED(IDC_BUTTON_EDIT, OnButtonEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditHolidayGroup message handlers

BOOL CEditHolidayGroup::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
void CEditHolidayGroup :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctID;
				sAcctID.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctID);
				pAccount->Release();
			}
			pDisp->Release();
		}
	//m_AcctList.SetCurSel(0);
	UpdateData(FALSE);
}

void CEditHolidayGroup::OnSelchangeComboAcctlist() 
{
	m_HolGrpList.ResetContent();
	LoadHolidayGroups();
}

void CEditHolidayGroup::OnSelchangeComboHolgrplist() 
{
	m_HolidayList.ResetContent();
	LoadHolidays();
	LoadHGDetails();
}

void CEditHolidayGroup::OnButtonEdit() 
{
	UpdateData();
	HRESULT hr;
	VARIANT vMasterHolidays;
	VARIANT vHolidays;
	long lCount = 0;

	int index_HG = m_HolGrpList.GetCurSel();
	if(index_HG<0)
		return;
	CString sOldHGName;
	m_HolGrpList.GetLBText(index_HG, sOldHGName);
	BSTR bstrOldHGName = m_sExHGName.AllocSysString();

	int index = m_AcctList.GetCurSel();
	if(index<0)
	{
		AfxMessageBox(_T("Invalid Account selected"));
		return;
	}

	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAcctID = _wtoi(sAcctID);
	pHolGrp->AccountID = lAcctID;

	BSTR bstrNewName = m_sNewHGName.AllocSysString();
	pHolGrp->HolGrpName = bstrNewName;


	

	vMasterHolidays.vt = VT_EMPTY;
	//********** end of filling Master holidays*******//

	IMasterHoliday *pIHoliday = NULL;
	IMasterHolidayPtr	pHol;
	pHol.CreateInstance(__uuidof(MasterHoliday));
	pHol->ApplyAllYears = m_bEveryYear;
	pHol->HolidayType = m_iHolType+1;
	pHol->Name = m_sHolName.AllocSysString();
	try
	{
		pHol->Day = m_lDay;
		pHol->Month = m_lMonth;
		pHol->Year = m_lYear;
	}
	catch(CString errStr)
	{
		AfxMessageBox(errStr);
		return;
	}

	COleSafeArray saHolidays;
	long uBound = 0;
	m_saHolidays.GetUBound(1,&uBound);
	saHolidays.CreateOneDim(VT_DISPATCH, m_saHolidays.GetOneDimSize()+1);
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		m_saHolidays.GetElement(&i,(void*)&pDisp);
		saHolidays.PutElement(&i, pDisp);
	}
	hr = pHol->QueryInterface(IID_IMasterHoliday, (void**)&pIHoliday);
	long lNext = uBound+1;
	if(SUCCEEDED(hr)) //timezone query interface succeeds if start
	{
		saHolidays.PutElement(&lNext,pIHoliday);
	}
	pHol->Release();
	vHolidays = saHolidays.Detach();
	long lStatus = 0;
	pApplication->EditHolidayGroup(bstrOldHGName,pHolGrp,vHolidays,&lStatus);
	if (lStatus == 105)
	{
		AfxMessageBox(L"Invalid account");
		return;
	}
	if(lStatus ==801)
	{
		AfxMessageBox(L"Holiday Group Name already exists");
		return;
	}
	if(lStatus ==802)
	{
		AfxMessageBox(L"Holiday Group Name cannot be Null");
		return;
	}
	if(lStatus ==803)
	{
		AfxMessageBox(L"Holiday Group Name Length must be less than 30 characters");
		return;
	}
	if(lStatus ==804)
	{
		AfxMessageBox(L"Holiday Group must contain atleast one holiday");
		return;
	}
	if(lStatus ==805)
	{
		AfxMessageBox(L"Holiday name is invalid");
		return;
	}
	if(lStatus ==806)
	{
		AfxMessageBox(L"Holiday name length is invalid");
		return;
	}
	if(lStatus ==807)
	{
		AfxMessageBox(L"Holiday group cant contain 2 or more holidays with same name");
		return;
	}
	if(lStatus ==808)
	{
		AfxMessageBox(L"Holiday group cant contain 2 or more holidays with same date");
		return;
	}
	if (lStatus == 705)
	{
		AfxMessageBox(L"Invalid holiday date");
		return;
	}
	if (lStatus == 706)
	{
		AfxMessageBox(L"Given master holiday does not exist");
		return;
	}
	if (lStatus == 703)
	{
		AfxMessageBox(L"Invalid Holiday type");
		return;
	}
	if (lStatus == 704)
	{
		AfxMessageBox(L"Invalid definition for every year");
		return;
	}
	if (lStatus == 1)
	{
		AfxMessageBox(L"Holiday group modification Failed");
		return;
	}

	else
	{
		AfxMessageBox(L"Holiday group modification succeeded");
		CDialog::OnOK();
	}
	
}

void CEditHolidayGroup::LoadHolidayGroups()
{
	int index = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(index,sAcctName);

	long lAccountID = _wtoi(sAcctName);
	_variant_t vHolGrps;
	vHolGrps.Clear();
	pApplication->GetHolidayGroupsByAcctID(lAccountID,&vHolGrps);
	if(vHolGrps.vt == VT_EMPTY)
	{
			AfxMessageBox(L"No Holiday groups");
			return;
	}	
	long uBound =0 ;
	IHolidayGroup *pHolGrp =NULL;
	COleSafeArray sa(vHolGrps);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	//BSTR bstrPanel;
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHolidayGroup,(void**)&pHolGrp);
		if (pHolGrp != NULL)
		{	
			CString sHolGrpID;
			sHolGrpID.Format(L"%ld",pHolGrp->HolGrpID);
			m_HolGrpList.AddString(sHolGrpID);	
			pHolGrp->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

void CEditHolidayGroup::LoadHolidays()
{
	int index = m_HolGrpList.GetCurSel();
	CString sHolidayName;
	m_HolGrpList.GetLBText(index,sHolidayName);

	long lHolGrpID = _wtoi(sHolidayName);
	_variant_t vHolidays;
	vHolidays.Clear();
	pApplication->GetHolidaysByHolidayGroupID(lHolGrpID,&vHolidays);
	long uBound =0 ;
	IMasterHoliday *pHol =NULL;
	m_saHolidays.Clear();
	m_saHolidays = COleSafeArray(vHolidays);
	m_saHolidays.GetUBound(1,&uBound);
	m_lHolCount = uBound;
	UpdateData(TRUE);
	//BSTR bstrPanel;
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		m_saHolidays.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IMasterHoliday,(void**)&pHol);
		if (pHol != NULL)
		{	
			//CString sHolID;
			//sHolID.Format("%ld",pHol->Name);
			m_HolidayList.AddString(pHol->Name);	
			pHol->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

void CEditHolidayGroup::LoadHGDetails()
{
	int index_acct = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(index_acct,sAcctName);
	long lAccountID = _wtoi(sAcctName);

	int index = m_HolGrpList.GetCurSel();
	CString sHolidayName;
	m_HolGrpList.GetLBText(index,sHolidayName);

	long lHolGrpID = _wtoi(sHolidayName);
	_variant_t vHolGrps;
	vHolGrps.Clear();
	pApplication->GetHolidayGroupsByAcctID(lAccountID,&vHolGrps);
	if(vHolGrps.vt == VT_EMPTY)
	{
			AfxMessageBox(L"No Holiday groups");
			return;
	}	
	long uBound =0 ;
	IHolidayGroup *pHolGrp =NULL;
	COleSafeArray sa(vHolGrps);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHolidayGroup,(void**)&pHolGrp);
		if (pHolGrp != NULL)
		{	
			if(lHolGrpID == pHolGrp->HolGrpID)
			{
				CString sHolgrpName = (LPCSTR) pHolGrp->HolGrpName;
				m_sNewHGName = sHolgrpName;
				m_sExHGName = sHolgrpName;
			}
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}